	function PLOT_ATT_Z(wT, Att, wTaxis, Amin)
 
	% 	Plots the attenuaton of a digital filter over a scale 0 to Amax
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2007-10-07
	% 	Modified by: 	LW 2008-07-09, 2014-09-12	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1			 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
 
	plot(wT, Att,'linewidth', lw);
 	axis([0 wTaxis 0 Amin]);	
 
	if wTaxis <= 0.05*pi
%		fs = 14;
		ax = [0 0.025*pi 0.05*pi];
		lab = {'0';'0.025\pi';'0.05\pi'};
	elseif wTaxis <= 0.1*pi
%		fs = 14;
		ax = [0 0.02*pi 0.04*pi 0.06*pi 0.08*pi 0.1*pi];
		lab = {'0';'0.02\pi';'0.04\pi';'0.06\pi';'0.08\pi';'0.1\pi'};v
	elseif wTaxis <= 0.15*pi
%		fs = 14;
		ax = [0 0.05*pi  0.1*pi 0.15*pi];
		lab = {'0';'0.05\pi';'0.1\pi';'0.15\pi'};
	elseif wTaxis <= 0.2*pi
%		fs = 14;
		ax = [0 0.05*pi 0.1*pi 0.15*pi 0.2*pi];
		lab = {'0';'0.05\pi';'0.1\pi';'0.15\pi';'0.2\pi'};	
	else
		ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
		lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};	
	end

 
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);	
	xtick(ax,lab);
	xlab = get(gca,'xlabel');
	% Use to move xlabel down if needed
	% set(xlab, 'position', get(xlab, 'position') - [0.3 -25 0])
	% set(xlab, 'position', get(xlab, 'position') - [0.1 8 0])
	grid on;
		
